const { contextBridge, shell, ipcRenderer } = require('electron');

try {
  contextBridge.exposeInMainWorld('electron', {
    shell,
    platform: process.platform,
    store: {
      set: (key, value) => ipcRenderer.send('setStoreValue', key, value),
      get: key => ipcRenderer.sendSync('getStoreValue', key),
      clear: () => ipcRenderer.send('clearStore'),
    },
    ui: {
      openFileDialog: props => ipcRenderer.invoke('openFileDialog', props),
      showCurrentWindow: () => ipcRenderer.send('showCurrentWindow'),
      showMessageBox: props => ipcRenderer.invoke('showMessageBox', props),
    },
    app: {
      quit: () => ipcRenderer.send('appQuit'),
      getPath: name => ipcRenderer.sendSync('getPath', name),
    },
  });
} catch (e) {
  console.error(e);
}
